/********************************************************** CHECK EMAIL FUNCTION ********************************************************/

function check_email(email) { 

	var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;

	return re.test(email);

}



/********************************************************** IS NUMERIC FUNCTION *********************************************************/

function is_numeric (mixed_var) {

  return (typeof mixed_var === 'number' || typeof mixed_var === 'string') && mixed_var !== '' && !isNaN(mixed_var);

}



/************************************************************ ON DOCUMENT LOAD **********************************************************/

$( document ).ready(function() {

	$( "input[type=text]").attr('autocomplete','off');

	$('.page_image').show();

	

	////////////////////////////////// CONTACT PAGE ////////////////////////////////

	$("[name=contact_send]").click(function() {

		var send = true;

		$('form.contact input').each(function(){

			if($(this).attr('type') == 'text')

			{

				if($(this).val() == '')

				{

					send = false;

					$(this).css('border','1px solid red');

				}

				else

				{

					$(this).css('border','1px solid #959595');

				}

			}

		});

		if(!check_email($('[name=contact_email]').val()))

		{

			send = false;

			$('[name=contact_email]').css('border','1px solid red');

		}

		else

		{

			$('[name=contact_email]').css('border','1px solid #959595');

		}

		if(send == false)

		{

			$('html,body').animate({

			scrollTop: $("form.contact").offset().top - 40},

			'slow');

			return false;

		}

	});

	////////////////////////////////// END CONTACT PAGE ////////////////////////////////

	

	

	////////////////////////////////// PROPERTY PAGE ///////////////////////////////////

	$('#product div.title h1').css('max-width',0);

	$('#product div.title h1').css('max-width',$('#product td:first').width() - 40);

	

	$("[name=property_contact]").click(function() {

		var send = true;

		$('td.product_right [type=text]').css('border','1px solid silver');

		

		if($('[name=pc_first_name]').val() == '')

		{

			send = false;

			$('[name=pc_first_name]').css('border','1px solid red');

		}



		if($('[name=pc_last_name]').val() == '')

		{

			send = false;

			$('[name=pc_last_name]').css('border','1px solid red');

		}



		if($('[name=pc_email]').val() == '' || !check_email($('[name=pc_email]').val()))

		{

			send = false;

			$('[name=pc_email]').css('border','1px solid red');

		}

		

		if(send == false)

		{

			$('html,body').animate({

			scrollTop: $(".product_right").offset().top},

			'slow');

			return false;

		}

	});

	////////////////////////////////// END PROPERTY PAGE ///////////////////////////////////



	

	///////////////////////////////////// HOME PAGE ////////////////////////////////////////

	if($('[name=input_slide_1]').val())

	{

		$('#bg').css('background-image','url(' + $('[name=input_slide_1]').val() + ')');

	}

	

	$('[name=slider]').val(1);

	

	var width = $(window).width();

	var height = $(window).height();

	

	$('#slider').css('height',(height - 130) + 'px');

	$('#slider a.arrow-right').css('margin-top',((height / 2) - 90) + 'px');

	$('#slider a.arrow-left').css('margin-top',((height / 2) - 90) + 'px');

	$('#slider div.slides').css('margin-top',(height - 170) + 'px');

	$('#slider div.thumb').css('margin-top',(height - 140) + 'px');

	

	var i = 30;

	$('#slider div.thumb').each(function(){

		$(this).css('margin-left', i + 'px');

		i = i + 150;

	});

	

	// Property slider set default page

	$('[name=property_images_page]').val(1);

	

	// Home search

	$("#search [type=text]").click(function() {

		$('html,body').animate({  scrollTop: $('#search').offset().top - 200},700);

	});

	$("#search [type=submit]").click(function() {

		if($(this).next('input').val() == 'Search by Property ID number' || $(this).next('input').val() == 'Enter your Transaction ID number')

		{

			$(this).next('input').css('border','1px solid red'); return false;

		}

	});

	///////////////////////////////////// HOME PAGE ////////////////////////////////////////

});





/*********************************************************** HOME SLIDER ****************************************************************/

function bgchange(direction)

{

	var slider_num = parseInt($('[name=slider]').val());

	var slider_total = parseInt($('[name=slider_total]').val());

		

	$('div.slides span').css('background','');

		

	if(is_numeric(direction))

	{

		if(slider_num == direction)

		{

			$('span.slides_' + slider_num).stop().css("background-color", "red").animate({ backgroundColor: "#3977b0"}, 500);

			return false;

		}

		else

		{

			$('#slider a.title_' + slider_num).hide('slide', {direction: 'left'}, 500);

			$('#slider div.description_' + slider_num).hide('slide', {direction: 'left'}, 500);

			slider_num = direction;

		}

	}

	else 

	{

		$('a.arrow-left').attr('data',$('a.arrow-left').attr('onclick'));

		$('a.arrow-right').attr('data',$('a.arrow-right').attr('onclick'));

			

		$('a.arrow-left').attr('onClick','return false');

		$('a.arrow-right').attr('onClick','return false');

			

		setTimeout(function() {

			$('a.arrow-left').attr('onClick',$('a.arrow-left').attr('data'));

			$('a.arrow-right').attr('onClick',$('a.arrow-right').attr('data'));

		}, 500);

		

		if($(direction).attr('class') == 'arrow-right')

		{	

			$('#slider a.title_' + slider_num).hide('slide', {direction: 'left'}, 500);

			$('#slider div.description_' + slider_num).hide('slide', {direction: 'left'}, 500);

			if(slider_num == slider_total)

			{

				slider_num = 1;

			}

			else

			{

				slider_num = slider_num + 1;

			}

		}

		else

		{

			$('#slider a.title_' + slider_num).hide('slide', {direction: 'left'}, 500);

			$('#slider div.description_' + slider_num).hide('slide', {direction: 'left'}, 500);

			if(slider_num == 1)

			{

				slider_num = slider_total;

			}

			else

			{

				slider_num = slider_num - 1;

			}

		}

	}

				

	$('[name=slider]').val(slider_num);

		

	$('div.slides span').removeClass('selected');

	$('span.slides_' + slider_num).addClass('selected');

				

	$('#bg').stop( true, true ).animate({opacity: 0.5}, 500, function() {

		$(this)

			.css({'background-image': 'url(' + $('[name=input_slide_' + slider_num + ']').val() + ')'})

			.animate({opacity: 1});

	});

				

	$('#slider a.title_' + slider_num).show('slide', {direction: 'left'}, 500);

	$('#slider div.description_' + slider_num).show('slide', {direction: 'left'}, 500);

}



/*********************************************************** PROPERTY SLIDER ************************************************************/

function slider(direcction)

{

	var property_images = parseInt($('[name=property_images]').val());

	var property_images_page = parseInt($('[name=property_images_page]').val());

	var arrows = 'false';

	

	if(direcction == 'next')

	{

		if((property_images > (property_images_page * 6)))

		{

			$('[name=property_images_page]').val(property_images_page + 1);

			for (var i = 6 * (property_images_page-1); i < ((6 * property_images_page) + 1); i++)

			{

				$('div.thumb_' + i).css('display','none');

				$('div.thumb_' + (i + 6)).css('display','inline-block');

			}

			arrows = 'true';

		}

	}

	else if(direcction == 'back')

	{

		if(property_images_page > 1)

		{

			$('[name=property_images_page]').val(property_images_page - 1);

			for (var i = (6 * (property_images_page-1) + 1); i < ((6 * property_images_page) + 1); i++)

			{

				$('div.thumb_' + i).css('display','none');

				$('div.thumb_' + (i - 6)).css('display','inline-block');

			}

			arrows = 'true';

		}

	}

	

	var property_images_page = parseInt($('[name=property_images_page]').val());

	

	if(arrows == 'true')

	{

		if(property_images_page == 1)

		{

			$('.slide-buttons span:first').addClass('opacity');

		}

		else

		{

			$('.slide-buttons span:first').removeClass('opacity');

		}

		

		if(property_images > (property_images_page * 6))

		{

			$('.slide-buttons span:last').removeClass('opacity');

		}

		else

		{

			$('.slide-buttons span:last').addClass('opacity');

		}

	}

}

